cap log close
drop _all

*log using "${Project}\Graphs\Bequest Shares\logfile", text replace

*set the exchange rate
local ex=0.698


set obs 4000

gen id=_n

gen finance=(id-1)/_N*200

replace finance= finance+0.000001 if finance==0


*In our framework final period MPC is an easy calculation

*let Z=(Beta*R*Phi)^-1/nu
*the n Z/(R+Z) is the MPC
*And we have kappa/Z as the annuity value



local DFJ_R=1.04

*Start by setting up the DFJ numbers --1998 prices
local DFJ_k=273
local DFJ_g=3.84
local DFJ_b=0.985
local DFJ_p=2360
local DFJ_s=1
local DFJ_rpi=642.6/1010
local DFJ_yearadj=1

local DFJ_R=1.04


*Start by setting up the DFJ AER numbers --1998 prices
local AER_k=13
local AER_g=2.83
local AER_b=0.994
local AER_p=39.7
local AER_s=1
local AER_rpi=1/1.21
local AER_yearadj=1

local AER_R=1.04

*Start by setting up the VFI numbers 2012/13 I think
local VFI_k=7.83
local VFI_g=5.27
local VFI_b=0.985
local VFI_p=1.09
local VFI_s=1
local VFI_rpi=957.6/1010
local VFI_yearadj=1

local VFI_R=1.04
*Start by setting up the lockwood numbers 2010 prices

local Lockwood_g=4.5
local Lockwood_b=0.84
local Lockwood_p=(0.96/0.04)^`Lockwood_g'

local Lockwood_k=17.1*(0.96/0.04)
local Lockwood_s=1
local Lockwood_rpi=881.9/1010
local Lockwood_yearadj=1

local Lockwood_R=1.04





*Start by setting up the Tan and Lee numbers (best guess, 1993 dollars?)
local Tan_k=14.067*(0.91/0.09)
local Tan_g=2.68
local Tan_b=0.985
local Tan_p=(0.91/0.09)^`Tan_g'
local Tan_s=1
local Tan_rpi=555.1/1010
local Tan_yearadj=1

local Tan_R=1.04




*Now do the singles case:
local DFJM_S_k=3516.5
local DFJM_S_p=6.8262*1000000
local DFJM_S_b=0.97^2   
local DFJM_S_g=3.7008
local DFJM_S_rpi=1.0

local DFJM_S_R=1.04^2
local DFJM_S_yearadj=(2+sqrt(`DFJM_S_R')-1)/sqrt(`DFJM_S_R')


*Now do the singles case:
local DFJM_C_k=3516.5
local DFJM_C_p=6.8262*1000000/2* (1.5281)^(1-3.7008)
local DFJM_C_b=0.97^2   
local DFJM_C_g=3.7008
local DFJM_C_rpi=1.0

local DFJM_C_R=1.04^2
local DFJM_C_yearadj=(2+sqrt(`DFJM_S_R')-1)/sqrt(`DFJM_S_R')



*Now do the singles case for the constrained estimator:
local robust_S_k=1152
local robust_S_p=104*1000
local robust_S_b=0.97^2   
local robust_S_g=3.641
local robust_S_rpi=1.0

local robust_S_R=1.04^2
local robust_S_yearadj=(2+sqrt(`robust_S_R')-1)/sqrt(`robust_S_R')


*Now do the singles case for the constrained estimator
local robust_C_k=1152
local robust_C_p=0104*1000/2* (1.526)^(1-3.641)
local robust_C_b=0.97^2   
local robust_C_g=3.641
local robust_C_rpi=1.0

local robust_C_R=1.04^2
local robust_C_yearadj=(2+sqrt(`robust_S_R')-1)/sqrt(`robust_S_R')

*Now do the singles estimates case:
local robust2_S_k=3.323*1000
local robust2_S_p=0.2571*1000000
local robust2_S_b=0.97^2   
local robust2_S_g=3.275
local robust2_S_rpi=1.0

local robust2_S_R=1.04^2
local robust2_S_yearadj=(2+sqrt(`robust2_S_R')-1)/sqrt(`robust2_S_R')

local robust3_S_k=0.934*1000
local robust3_S_p=0.01158*1000000
local robust3_S_b=0.97^2   
local robust3_S_g=3.565
local robust3_S_rpi=1.0

local robust3_S_R=1.04^2
local robust3_S_yearadj=(2+sqrt(`robust3_S_R')-1)/sqrt(`robust3_S_R')

foreach x in DFJ VFI Lockwood Tan DFJM_S DFJM_C AER robust_S robust_C robust2_S robust3_S{

local `x'_k=``x'_k'/``x'_rpi'

local Z_`x'=``x'_b'*``x'_p*'*``x'_R'
local Z_`x'= `Z_`x''^(-1/``x'_g')

gen MPC_`x'=`Z_`x''/(1+`Z_`x'')

gen threshold_`x'=``x'_k'*`Z_`x''

*Adjust 1 year to 2 year! See John's notes to go from 2 year back forward to 1 year back

replace MPC_`x'=MPC_`x'/``x'_yearadj'

replace threshold_`x'=threshold_`x'/``x'_yearadj'


gen `x'=(1-MPC_`x')*(finance-threshold_`x')
replace `x'=0 if `x'<0


replace `x'=`x'/finance


}
*label var Hom "Homogenous Preferences"

label var DFJ "DFJ ('10)"
label var Lockwood "Lockwood"
label var Tan "L&T"
label var VFI "ABCST"

label var AER "DFJ ('16)"

label var DFJM_S "Singles"
label var DFJM_C "Couples"

label var robust_S "Singles"
label var robust_C "Couples"


sum threshold*
sum MPC*

twoway (line DFJM_S finance if finance<=500, sort lcolor(red) lpattern(- -)  ) || (line DFJ finance if finance<=500, sort lcolor(black) lpattern(l)    ) || (line Lockwood finance if finance<=500, sort) || (line VFI finance if finance<=500, sort lcolor(gray) lpattern(_)  ) || (line Tan finance if finance<=500, sort lpattern(-.) ) || (line AER finance if finance<=500, sort lpattern(l) ), yscale( range(0 1)) ylabel(0(0.2)1, labsize(medlarge)) name(literature_USD, replace) ytitle("Share Allocated to Bequests", size(large)) xtitle("Cash on Hand (1000s USD)", size(large)) legend(position(6) rows(1) size(medlarge)) ytick(0(0.1)1) xlabel(0(50)200, labsize(medlarge))

graph export "C:\Dropbox\ERIC_couples\graphs\literature_USDAER.pdf", as(pdf)  replace



twoway (line DFJM_S finance if finance<=500, sort lwidth(medthick) lcolor(red) lpattern(- -)  ) || (line DFJ finance if finance<=500, sort lwidth(medthick) lcolor(black) lpattern(l)    ) || (line Lockwood finance if finance<=500, sort lwidth(medthick)) || (line VFI finance if finance<=500, sort lwidth(medthick) lcolor(gray) lpattern(_)  ) || (line Tan finance if finance<=500, sort lwidth(medthick) lpattern(-.) ) || (line AER finance if finance<=500, sort lwidth(medthick) lpattern(l) ), yscale( range(0 1)) ylabel(0(0.2)1, labsize(medlarge)) name(literature_USD, replace) ytitle("Share Allocated to Bequests", size(large)) xtitle("Cash on Hand (1000s USD)", size(large)) legend(position(6) rows(1) size(medlarge)) ytick(0(0.1)1) xlabel(0(50)200, labsize(medlarge))

graph export "C:\Dropbox\ERIC_couples\graphs\literature_USDAER.pdf", as(pdf) replace

twoway (line DFJM_S finance if finance<=500, sort lwidth(medthick) lcolor(red) lpattern(- -)  ) || (line DFJM_C finance if finance<=500, sort lwidth(medthick) lcolor(blue) lpattern(l)    ) , yscale( range(0 1)) ylabel(0(0.2)1, labsize(medlarge)) name(literature_USD, replace) ytitle("Share Allocated to Bequests", size(large)) xtitle("Cash on Hand (1000s USD)", size(large)) legend(position(6) rows(1) size(medlarge)) ytick(0(0.1)1) xlabel(0(50)200, labsize(medlarge))

graph export "C:\Dropbox\ERIC_couples\graphs\bequest_shares.pdf", as(pdf) replace

twoway (line robust_S finance if finance<=500, sort lwidth(medthick) lcolor(red) lpattern(- -)  ) || (line robust_C finance if finance<=500, sort lwidth(medthick) lcolor(blue) lpattern(l)    ) , yscale( range(0 1)) ylabel(0(0.2)1, labsize(medlarge)) name(literature_USD, replace) ytitle("Share Allocated to Bequests", size(large)) xtitle("Cash on Hand (1000s USD)", size(large)) legend(position(6) rows(1) size(medlarge)) ytick(0(0.1)1) xlabel(0(50)200, labsize(medlarge))

graph export "C:\Dropbox\ERIC_couples\graphs\bequest_sharesRobust.pdf", as(pdf) replace


twoway (line robust_S finance if finance<=500, sort lwidth(medthick) lcolor(red) lpattern(- -)  ) || (line DFJM_S finance if finance<=500, sort lwidth(medthick) lcolor(blue) lpattern(l)    ) , yscale( range(0 1)) ylabel(0(0.2)1, labsize(medlarge)) name(literature_USD, replace) ytitle("Share Allocated to Bequests", size(large)) xtitle("Cash on Hand (1000s USD)", size(large)) legend(position(6) rows(1) size(medlarge)) ytick(0(0.1)1) xlabel(0(50)200, labsize(medlarge)) legend( label(1 "Constrained") label(2 "Baseline"))


graph export "C:\Dropbox\ERIC_couples\graphs\bequest_sharesRobustvsBaseline.pdf", as(pdf) replace

twoway (line robust_S finance if finance<=500, sort lwidth(medthick) lcolor(red) lpattern(- -)  ) || (line DFJM_S finance if finance<=500, sort lwidth(medthick) lcolor(blue) lpattern(l)    ) , yscale( range(0 1)) ylabel(0(0.2)1, labsize(medlarge)) name(literature_USD, replace) ytitle("Share Allocated to Bequests", size(large)) xtitle("Cash on Hand (1000s USD)", size(large)) legend(position(6) rows(1) size(medlarge)) ytick(0(0.1)1) xlabel(0(50)200, labsize(medlarge)) legend( label(1 "Constrained") label(2 "Baseline"))


graph export "C:\Dropbox\ERIC_couples\graphs\bequest_sharesRobustvsBaselineS.pdf", as(pdf) replace


twoway (line robust_C finance if finance<=500, sort lwidth(medthick) lcolor(red) lpattern(- -)  ) || (line DFJM_C finance if finance<=500, sort lwidth(medthick) lcolor(blue) lpattern(l)    ) , yscale( range(0 1)) ylabel(0(0.2)1, labsize(medlarge)) name(literature_USD, replace) ytitle("Share Allocated to Bequests", size(large)) xtitle("Cash on Hand (1000s USD)", size(large)) legend(position(6) rows(1) size(medlarge)) ytick(0(0.1)1) xlabel(0(50)200, labsize(medlarge)) legend( label(1 "Constrained") label(2 "Baseline"))


graph export "C:\Dropbox\ERIC_couples\graphs\bequest_sharesRobustvsBaselineC.pdf", as(pdf) replace

twoway (line robust2_S finance if finance<=500, sort lwidth(medthick)  lcolor(blue) lpattern(l) ) || (line DFJM_S finance if finance<=500, sort lwidth(medthick) lcolor(red) lpattern(- -)  ) , yscale( range(0 1)) ylabel(0(0.2)1, labsize(medlarge)) name(literature_USD, replace) ytitle("Share Allocated to Bequests", size(large)) xtitle("Cash on Hand (1000s USD)", size(large)) legend(position(6) rows(1) size(medlarge)) ytick(0(0.1)1) xlabel(0(50)200, labsize(medlarge)) legend( label(1 "Singles Only") label(2 "Baseline Model"))

graph export "C:\Dropbox\ERIC_couples\graphs\bequest_sharesRobustInitSingles.pdf", as(pdf) replace

